/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.cobalt.internal.doubles;

import cc.tweaked.cobalt.internal.doubles.UnsignedValues;
import java.util.Arrays;
import org.checkerframework.checker.signedness.qual.Unsigned;

final class DecimalRepBuf {
    private static final char ASCII_ZERO = '0';
    private static final int DECIMAL_OVERFLOW = 58;
    private final char[] buffer;
    private boolean sign;
    private int length;
    private int pointPosition;

    public DecimalRepBuf(int size) {
        this.buffer = new char[size];
        this.length = 0;
        this.pointPosition = 0;
    }

    public void addLength(int size) {
        this.length += size;
    }

    public void append(@Unsigned long digit) {
        this.doAppend(UnsignedValues.digitToChar(digit));
    }

    public void append(@Unsigned int digit) {
        this.doAppend(UnsignedValues.digitToChar(digit));
    }

    public char charAt(int pos) {
        return this.buffer[pos];
    }

    public char lastChar() {
        return this.buffer[this.length - 1];
    }

    public int incrementLast() {
        int overflow = 0;
        int n = this.length - 1;
        this.buffer[n] = (char)(this.buffer[n] + '\u0001');
        for (int i = this.length - 1; i > 0 && this.buffer[i] == ':'; --i) {
            this.buffer[i] = 48;
            int n2 = i - 1;
            this.buffer[n2] = (char)(this.buffer[n2] + '\u0001');
        }
        if (this.buffer[0] == ':') {
            this.buffer[0] = 49;
            overflow = 1;
        }
        return overflow;
    }

    public void incrementLastNoOverflow() {
        if (this.buffer[this.length - 1] == '9') {
            throw new ArithmeticException("Last digit is '9' and so would overflow");
        }
        int n = this.length - 1;
        this.buffer[n] = (char)(this.buffer[n] + '\u0001');
    }

    public int length() {
        return this.length;
    }

    public void reverseLast(int start) {
        int i = start;
        for (int j = this.length - 1; i < j; ++i, --j) {
            char t = this.buffer[i];
            this.buffer[i] = this.buffer[j];
            this.buffer[j] = t;
        }
    }

    public void clearBuf() {
        this.length = 0;
    }

    public void reset() {
        this.length = 0;
        this.pointPosition = 0;
    }

    public void roundUp() {
        if (this.length() == 0) {
            this.append(1);
            this.setPointPosition(1);
        } else {
            this.pointPosition += this.incrementLast();
        }
    }

    public void setCharAt(int index, @Unsigned int digit) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.buffer[index] = UnsignedValues.digitToChar(digit);
    }

    public CharSequence subSequence(final int start, final int end) {
        return new CharSequence(){

            @Override
            public int length() {
                return end - start;
            }

            @Override
            public char charAt(int index) {
                return DecimalRepBuf.this.buffer[start + index];
            }

            @Override
            public CharSequence subSequence(int st, int e) {
                return DecimalRepBuf.this.subSequence(start + st, start + e);
            }

            @Override
            public String toString() {
                return String.valueOf(DecimalRepBuf.this.buffer, start, end - start);
            }
        };
    }

    public String toString() {
        return String.valueOf(this.buffer, 0, this.length);
    }

    public void trimZeros() {
        int firstNonZero;
        while (this.length > 0 && this.buffer[this.length - 1] == '0') {
            --this.length;
        }
        for (firstNonZero = 0; firstNonZero < this.length && this.buffer[firstNonZero] == '0'; ++firstNonZero) {
        }
        if (firstNonZero != 0) {
            System.arraycopy(this.buffer, firstNonZero, this.buffer, 0, this.length - firstNonZero);
            this.length -= firstNonZero;
            this.pointPosition -= firstNonZero;
        }
    }

    public void truncateZeros(boolean exponential) {
        int stop;
        int n = stop = exponential ? 1 : Math.max(1, this.pointPosition);
        while (this.length > stop && this.buffer[this.length - 1] == '0') {
            --this.length;
        }
    }

    public void truncateAllZeros() {
        while (this.length > 0 && this.buffer[this.length - 1] == '0') {
            --this.length;
        }
    }

    public void zeroExtend(int targetLength) {
        if (this.length < targetLength) {
            Arrays.fill(this.buffer, this.length, targetLength, '0');
            this.length = targetLength;
        }
    }

    private void doAppend(char ch) {
        this.buffer[this.length++] = ch;
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public boolean getSign() {
        return this.sign;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    public int getPointPosition() {
        return this.pointPosition;
    }

    void setPointPosition(int point) {
        this.pointPosition = point;
    }
}

